/*
 * Decompiled with CFR 0.152.
 */
import common.Config;
import common.Log;
import common.Spacecraft;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import telemServer.ImageProcess;
import telemServer.ServerConfig;
import telemServer.ServerProcess;
import telemServer.StpFileProcessException;
import telemetry.PayloadDbStore;
import telemetry.frames.Frame;

public class FoxTelemServer {
    public static String version = "Version 0.38d - 18 Sep 2022";
    public static int port = Config.tcpPort;
    static int sequence = 0;
    private static final int MAX_SEQUENCE = 1000;
    static int poolSize = 1;
    static final String usage = "FoxServer user database [-vr] [-s dir] [-f dir]\n-v - Version Information\n-s <dir> - Process all of the stp files in the specified directory and load them into the db\n-f <dir> - Read the stp files in the specified directory and fix the STP_HEADER table db\n-r - Reprocess the radiation data and generate the secondary payloads\n-hpk - Reprocess the Herci High Speed data and generate the packet payloads\n";
    static Thread imageThread;
    static ImageProcess imageProcess;

    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help")) {
                System.out.println(usage);
                System.exit(0);
            } else if (args[0].equalsIgnoreCase("-v") || args[0].equalsIgnoreCase("-version")) {
                System.out.println("AMSAT Fox Server. Version " + version);
                System.exit(0);
            } else {
                System.out.println(usage);
                System.exit(1);
            }
        }
        if (args.length < 2) {
            System.out.println(usage);
            System.exit(1);
        }
        String u = args[0];
        String db = args[1];
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String p = in.readLine();
        if (p == null || p.isEmpty()) {
            System.out.println("Missing password");
            System.exit(2);
        }
        Config.logging = true;
        Log.init("FoxServer");
        Log.showGuiDialogs = false;
        Log.setStdoutEcho(false);
        Config.splitCanPackets = false;
        try {
            FoxTelemServer.makeExceptionDir();
        }
        catch (IOException e1) {
            e1.printStackTrace(Log.getWriter());
            Log.alert("FATAL: Cannot create exception dir");
        }
        Log.println("Starting FoxServer: " + version);
        Log.println("Listening on port: " + port);
        Config.currentDir = System.getProperty("user.dir");
        Config.spacecraftDir = String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR;
        Config.serverInit();
        ServerConfig.init();
        if (args.length == 3) {
            if (args[2].equalsIgnoreCase("-r")) {
                Log.println("AMSAT Fox Server. \nPROCESS RAD DATA: ");
                FoxTelemServer.processRadData(u, p, db);
                System.exit(0);
            } else if (args[2].equalsIgnoreCase("-hpk")) {
                Log.println("AMSAT Fox Server. \nPROCESS HERCI PACKET DATA: ");
                FoxTelemServer.processHerciPktData(u, p, db);
                System.exit(0);
            } else {
                System.out.println(usage);
                System.exit(1);
            }
        } else if (args.length == 4) {
            String dir;
            if (args[2].equalsIgnoreCase("-s")) {
                dir = args[3];
                Log.println("AMSAT Fox Server. \nSTP FILE LOAD FROM DIR: " + dir);
                FoxTelemServer.importStp(dir, false, u, p, db);
                System.exit(0);
            } else if (args[2].equalsIgnoreCase("-f")) {
                dir = args[3];
                Log.println("AMSAT Fox Server. \nSTP FILE fix: " + dir);
                FoxTelemServer.fixStp(dir);
                System.exit(0);
            } else {
                System.out.println(usage);
                System.exit(1);
            }
        } else if (args.length > 4) {
            System.out.println(usage);
            System.exit(1);
        }
        Config.splitCanPackets = false;
        ServerSocket serverSocket = null;
        boolean listening = true;
        ExecutorService pool = null;
        try {
            serverSocket = new ServerSocket(port);
            pool = Executors.newFixedThreadPool(poolSize);
        }
        catch (IOException e) {
            Log.println("Could not listen on port: " + port);
            Log.alert("FATAL: Could not listen on port: " + port);
        }
        imageProcess = new ImageProcess(FoxTelemServer.initPayloadDB(u, p, db));
        imageThread = new Thread(imageProcess);
        imageThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        imageThread.start();
        int retries = 0;
        int RETRY_LIMIT = 10;
        while (listening) {
            try {
                Log.println("Waiting for connection ...");
                pool.execute(new ServerProcess(u, p, db, serverSocket.accept(), sequence++));
                retries = 0;
            }
            catch (SocketTimeoutException s) {
                Log.println("Socket timed out! - trying to continue\t");
                ++retries;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                Log.println("Socket Error: waiting to see if we recover: " + e.getMessage());
                ++retries;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (sequence == 1000) {
                sequence = 0;
            }
            if (retries != RETRY_LIMIT) continue;
            Log.println("Max Socket Retries hit: Terminating Server");
            listening = false;
        }
        try {
            serverSocket.close();
            pool.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
    }

    public static PayloadDbStore initPayloadDB(String u, String p, String db) {
        return new PayloadDbStore(u, p, db);
    }

    public static void makeExceptionDir() throws IOException {
        File aFile = new File("exception");
        if (aFile.isDirectory()) {
            return;
        }
        aFile.mkdir();
        if (!aFile.isDirectory()) {
            throw new IOException("Can not make the exception dir");
        }
    }

    private static void processRadData(String u, String p, String db) {
        Config.payloadStore = FoxTelemServer.initPayloadDB(u, p, db);
        Config.payloadStore.initRad2();
    }

    private static void processHerciPktData(String u, String p, String db) {
        Config.payloadStore = FoxTelemServer.initPayloadDB(u, p, db);
        Config.payloadStore.initHerciPackets();
    }

    private static void fixStp(String stpDir) {
        String dir = stpDir;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator + dir;
        }
        Log.println("FIX STP files in " + dir);
        File folder = new File(dir);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile()) {
                    try {
                        Frame f = Frame.loadStp(listOfFiles[i].getPath(), true);
                        if (f != null && !f.corrupt) {
                            Config.payloadStore.updateStpHeader(f);
                        }
                    }
                    catch (StpFileProcessException e) {
                        Log.println("STP IMPORT ERROR: " + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                    }
                    catch (IOException e) {
                        Log.println("STP IO ERROR: " + e.getMessage());
                        e.printStackTrace();
                    }
                    if (i % 100 == 0) {
                        Log.println("Loaded: " + 100.0 * (double)i / (double)listOfFiles.length + "%");
                    }
                }
                ++i;
            }
            Log.println("Files Processed: " + listOfFiles.length);
        }
    }

    private static void importStp(String stpDir, boolean delete, String u, String p, String db) {
        String dir = stpDir;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator + dir;
        }
        Log.println("IMPORT STP from " + dir);
        File folder = new File(dir);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile()) {
                    try {
                        Frame frame = Frame.importStpFile(u, p, db, listOfFiles[i], false);
                    }
                    catch (StpFileProcessException e) {
                        Log.println("STP IMPORT ERROR: " + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                    }
                    if (i % 100 == 0) {
                        Log.println("Loaded: " + 100.0 * (double)i / (double)listOfFiles.length + "%");
                    }
                }
                ++i;
            }
            Log.println("Files Processed: " + listOfFiles.length);
        }
    }
}

