/*
 * Decompiled with CFR 0.152.
 */
import common.Config;
import common.Log;
import common.Spacecraft;
import java.io.File;
import java.io.IOException;
import telemServer.StpFileProcessException;
import telemetry.Format.FormatFrame;
import telemetry.frames.Frame;

public class FoxStp {
    public static final String version = "Version 0.1 - 7 December 2015";
    public static final String usage = "FoxStp [-vrW] <stp>\n-v - Verbose\n-r - Output raw values\n-W - Output timestamps for WOD only\nstp - The STP file to process\n";
    static boolean wodTimestampsOnly = false;

    public static void main(String[] args) {
        Config.logging = false;
        Log.showGuiDialogs = false;
        Log.setStdoutEcho(false);
        Config.currentDir = System.getProperty("user.dir");
        Config.spacecraftDir = String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR;
        Config.foxTelemCalcsPosition = false;
        Config.basicInit();
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help")) {
                System.out.println(usage);
                System.exit(0);
            }
            if (args[0].equalsIgnoreCase("-v") || args[0].equalsIgnoreCase("-version")) {
                Log.setStdoutEcho(true);
            }
            if (args[0].equalsIgnoreCase("-W")) {
                wodTimestampsOnly = true;
                FoxStp.processStpFile(args[1]);
                System.exit(0);
            }
            args[0].equalsIgnoreCase("-r");
            if (args[0] != null) {
                System.out.println("FoxStp: Version 0.1 - 7 December 2015");
                FoxStp.processStpFile(args[0]);
                System.exit(0);
            }
        } else {
            System.out.println(usage);
        }
    }

    private static void processStpFile(String f) {
        try {
            Frame decodedFrame = Frame.loadStp(f, false);
            if (decodedFrame != null && !decodedFrame.corrupt) {
                if (wodTimestampsOnly) {
                    FormatFrame bpsk = (FormatFrame)decodedFrame;
                    System.out.print(decodedFrame.toWodTimestampString(bpsk.getHeader().resets, bpsk.getHeader().getUptime()));
                } else {
                    System.out.println(decodedFrame.toString());
                }
            }
        }
        catch (StpFileProcessException e) {
            Log.println("ERROR PROCESSING: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

