/*
 * Decompiled with CFR 0.152.
 */
package telemetry.payloads;

import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.payloads.PayloadRtValues;

public class PayloadWOD
extends PayloadRtValues {
    public static final String WOD_RESETS = "WODTimestampReset";
    public static final String WOD_UPTIME = "WODTimestampUptime";

    public PayloadWOD(BitArrayLayout lay) {
        super(lay);
    }

    public PayloadWOD(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, date, st, lay);
    }

    @Override
    protected void init() {
        this.type = 10;
        this.fieldValue = new int[this.layout.NUMBER_OF_FIELDS];
    }

    @Override
    public void captureHeaderInfo(int id, long uptime, int resets) {
        this.copyBitsToFields();
        this.id = id;
        this.reportDate = PayloadWOD.fileDateStamp();
    }

    @Override
    public void copyBitsToFields() {
        super.copyBitsToFields();
        this.resets = this.getRawValue(WOD_RESETS);
        this.uptime = this.getRawValue(WOD_UPTIME);
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + "WOD Telemetry:\n";
        int i = 0;
        while (i < this.layout.fieldName.length) {
            s = String.valueOf(s) + this.layout.fieldName[i] + ": " + this.fieldValue[i] + ",   ";
            if ((i + 1) % 6 == 0) {
                s = String.valueOf(s) + "\n";
            }
            ++i;
        }
        return s;
    }
}

