/*
 * Decompiled with CFR 0.152.
 */
package telemetry.conversion;

import common.Spacecraft;
import telemetry.FramePart;

public class MathExpression {
    int pos = -1;
    int ch;
    String str;
    FramePart framePart;
    Spacecraft spacecraft;
    double rawValue = 0.0;

    public MathExpression(String str, double rawValue) {
        this.str = str;
        this.rawValue = rawValue;
    }

    void nextChar() {
        this.ch = ++this.pos < this.str.length() ? (int)this.str.charAt(this.pos) : -1;
    }

    boolean eat(int charToEat) {
        while (this.ch == 32 || this.ch == 9 || this.ch == 34) {
            this.nextChar();
        }
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    public double parse(FramePart framePart, Spacecraft spacecraft) {
        this.framePart = framePart;
        this.spacecraft = spacecraft;
        this.nextChar();
        double x = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new RuntimeException("Unexpected character: " + (char)this.ch + " at position " + this.pos);
        }
        return x;
    }

    double parseExpression() {
        double x = this.parseTerm();
        while (true) {
            if (this.eat(43)) {
                x += this.parseTerm();
                continue;
            }
            if (!this.eat(45)) break;
            x -= this.parseTerm();
        }
        return x;
    }

    double parseTerm() {
        double x = this.parseFactor();
        while (true) {
            if (this.eat(94)) {
                x = Math.pow(x, this.parseFactor());
            }
            if (this.eat(42)) {
                x *= this.parseFactor();
                continue;
            }
            if (!this.eat(47)) break;
            x /= this.parseFactor();
        }
        return x;
    }

    boolean validChar(int ch) {
        if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
            return true;
        }
        return ch == 95;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    double parseFactor() {
        double x;
        if (this.eat(43)) {
            return this.parseFactor();
        }
        if (this.eat(45)) {
            return -this.parseFactor();
        }
        int startPos = this.pos;
        if (!this.eat(40)) {
            if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    this.nextChar();
                }
                return Double.parseDouble(this.str.substring(startPos, this.pos));
            }
            if (!this.validChar(this.ch)) throw new RuntimeException("Unexpected term ending: " + (char)this.ch + " at position " + this.pos);
            while (this.validChar(this.ch) || this.ch >= 48 && this.ch <= 57) {
                this.nextChar();
            }
            String func = this.str.substring(startPos, this.pos);
            if (func.equalsIgnoreCase("x")) {
                return this.rawValue;
            }
            if (this.framePart.hasFieldName(func)) {
                return this.framePart.getDoubleValue(func, this.spacecraft);
            }
            x = this.parseFactor();
            if (func.equalsIgnoreCase("sqrt")) {
                return Math.sqrt(x);
            }
            if (func.equalsIgnoreCase("sin")) {
                return Math.sin(x);
            }
            if (func.equalsIgnoreCase("cos")) {
                return Math.cos(x);
            }
            if (func.equalsIgnoreCase("tan")) {
                return Math.tan(x);
            }
            if (func.equalsIgnoreCase("acos")) {
                return Math.acos(x);
            }
            if (func.equalsIgnoreCase("asin")) {
                return Math.asin(x);
            }
            if (func.equalsIgnoreCase("atan")) {
                return Math.atan(x);
            }
            if (!func.equalsIgnoreCase("abs")) throw new RuntimeException("Unknown function or variable: " + func);
            return Math.abs(x);
        }
        x = this.parseExpression();
        this.eat(41);
        return x;
    }
}

