/*
 * Decompiled with CFR 0.152.
 */
package telemetry.conversion;

import common.Spacecraft;
import telemetry.conversion.Conversion;

public class ConversionCurve
extends Conversion {
    public static final int CSF_FILE_ROW_LENGTH = 8;
    public double a;
    public double b;
    public double c;
    public double d;
    public double e;
    public double f;
    private String description;

    public ConversionCurve(String[] values, Spacecraft fox) {
        super(values[0], fox);
        if (values.length < 8) {
            throw new IllegalArgumentException("Conversion File row has wrong number of values: " + values.length);
        }
        this.name = values[0];
        try {
            this.a = Double.parseDouble(values[1]);
            this.b = Double.parseDouble(values[2]);
            this.c = Double.parseDouble(values[3]);
            this.d = Double.parseDouble(values[4]);
            this.e = Double.parseDouble(values[5]);
            this.f = Double.parseDouble(values[6]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("For Curve " + this.name + ", coeeficients are not all parsable numbers");
        }
        this.description = values[7];
    }

    @Override
    public double calculate(double x) {
        double y = this.f * Math.pow(x, 5.0) + this.e * Math.pow(x, 4.0) + this.d * Math.pow(x, 3.0) + this.c * Math.pow(x, 2.0) + this.b * x + this.a;
        return y;
    }

    @Override
    public String calculateString(double x) {
        String s = String.format("%2.1f", x);
        return s;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.name + ": " + this.a + " + " + this.b + "x + " + this.c + "x^2 + " + this.d + "x^3 + " + this.e + "x^4 + " + this.f + "x^5 " + this.description;
        return s;
    }
}

