/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.SatPayloadStore;
import telemetry.SortedArrayList;
import telemetry.SortedFramePartArrayList;
import telemetry.TableSeg;
import telemetry.uw.UwCanPacket;

public class SatPayloadTable {
    public static final int MAX_DATA_LENGTH = 62;
    public static final int MAX_SEGMENT_SIZE = 1000;
    private SortedArrayList<TableSeg> tableIdx = new SortedArrayList(2);
    private static final int INITIAL_SIZE = 2;
    private String fileName;
    private String baseFileName;
    private SortedFramePartArrayList rtRecords;
    private boolean updated = false;
    private boolean storeMode = false;
    private BitArrayLayout layout;
    private boolean isFOXDB_V3;
    boolean deleteLock = false;

    public SatPayloadTable(int size, String name, BitArrayLayout layout, boolean storeMode, boolean isFOXDB_V3) throws IOException {
        this.baseFileName = name;
        this.layout = layout;
        this.storeMode = storeMode;
        this.isFOXDB_V3 = isFOXDB_V3;
        String dir = SatPayloadTable.getDir();
        this.fileName = String.valueOf(dir) + "FOXDB" + File.separator + name;
        this.rtRecords = new SortedFramePartArrayList(size);
        this.loadIdx();
        this.updated = true;
    }

    public SortedFramePartArrayList getFrameParts(int fromReset, long fromUptime, int period, boolean reverse) throws IOException {
        if (this.rtRecords == null) {
            return null;
        }
        this.loadSegments(fromReset, fromUptime, period, reverse);
        return this.rtRecords;
    }

    public void setUpdated(boolean t) {
        this.updated = t;
    }

    public boolean getUpdated() {
        return this.updated;
    }

    public static String getDir() {
        String dir = "";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator;
        }
        return dir;
    }

    public int getSize() {
        int s = 0;
        for (TableSeg t : this.tableIdx) {
            s += t.records;
        }
        return s;
    }

    public boolean hasFrame(int id, long uptime, int resets) throws IOException {
        TableSeg seg = this.loadSeg(resets, uptime, false);
        return this.rtRecords.hasFrame(id, uptime, resets);
    }

    public FramePart getLatest() throws IOException {
        if (this.tableIdx.size() > 0) {
            TableSeg lastSeg = (TableSeg)this.tableIdx.get(this.tableIdx.size() - 1);
            if (!lastSeg.isLoaded()) {
                this.load(lastSeg);
            } else {
                lastSeg.accessed();
            }
            if (this.rtRecords.size() == 0) {
                return null;
            }
            return (FramePart)this.rtRecords.get(this.rtRecords.size() - 1);
        }
        return null;
    }

    public FramePart getFrame(int id, long uptime, int resets, boolean prev) throws IOException {
        TableSeg seg = this.loadSeg(resets, uptime, prev);
        if (seg == null) {
            return null;
        }
        if (seg.records == 0) {
            return null;
        }
        if (prev) {
            int i = this.rtRecords.getNearestPrevFrameIndex(id, uptime, resets);
            if (i == -1) {
                return null;
            }
            return (FramePart)this.rtRecords.get(i);
        }
        int i = this.rtRecords.getNearestFrameIndex(id, uptime, resets);
        if (i == -1) {
            return null;
        }
        return (FramePart)this.rtRecords.get(i);
    }

    public FramePart getFrame(int id, long uptime, int resets, int type, boolean prev) throws IOException {
        TableSeg seg = this.loadSeg(resets, uptime, prev);
        if (prev) {
            if (seg == null) {
                return null;
            }
            int i = this.rtRecords.getNearestPrevFrameIndex(id, uptime, resets, type);
            if (i == -1) {
                return null;
            }
            return (FramePart)this.rtRecords.get(i);
        }
        int i = this.rtRecords.getNearestFrameIndex(id, uptime, resets, type);
        if (i == -1) {
            return null;
        }
        return (FramePart)this.rtRecords.get(i);
    }

    public String[][] getPayloadData(int period, int id, int fromReset, long fromUptime, int length, boolean reverse) throws IOException {
        return this.getPayloadData(period, id, fromReset, fromUptime, length, false, reverse);
    }

    public synchronized String[][] getPayloadData(int period, int id, int fromReset, long fromUptime, int length, boolean returnType, boolean reverse) throws IOException {
        boolean exactMatch = false;
        if (period == 0) {
            exactMatch = true;
            period = 100;
        }
        if (this.rtRecords == null) {
            return null;
        }
        this.deleteLock = true;
        try {
            this.loadSegments(fromReset, fromUptime, period, reverse);
            if (this.rtRecords.size() == 0) {
                return null;
            }
            int start = 0;
            int end = 0;
            if (reverse) {
                if (exactMatch) {
                    end = this.rtRecords.getNearestFrameIndex(id, fromUptime, fromReset);
                    start = this.rtRecords.getNearestPrevFrameIndex(id, fromUptime, fromReset);
                } else {
                    start = this.rtRecords.size() - period;
                    end = this.rtRecords.size();
                }
            } else {
                start = this.rtRecords.getNearestFrameIndex(id, fromUptime, fromReset);
                if (start == -1) {
                    start = this.rtRecords.size() - period;
                }
                end = exactMatch ? this.rtRecords.getNearestPrevFrameIndex(id, fromUptime, fromReset) : start + period;
            }
            if (end > this.rtRecords.size()) {
                end = this.rtRecords.size();
            }
            if (end < start) {
                end = start;
            }
            if (start < 0) {
                start = 0;
            }
            if (start > this.rtRecords.size()) {
                start = this.rtRecords.size();
            }
            if (start == end) {
                end = start + 1;
            }
            int[][] results = new int[end - start][];
            String[] upTime = new String[end - start];
            String[] resets = new String[end - start];
            String[] type = null;
            if (returnType) {
                type = new String[end - start];
            }
            int j = results.length - 1;
            int i = end - 1;
            while (i >= start) {
                results[j] = ((FramePart)this.rtRecords.get(i)).getFieldValues();
                if (returnType) {
                    type[j] = "" + ((FramePart)this.rtRecords.get((int)i)).type;
                }
                upTime[j] = "" + ((FramePart)this.rtRecords.get(i)).getUptime();
                resets[j--] = "" + ((FramePart)this.rtRecords.get(i)).getResets();
                --i;
            }
            int offset = 2;
            if (returnType) {
                offset = 3;
            }
            String[][] resultSet = new String[end - start][length + offset];
            int r = 0;
            while (r < end - start) {
                resultSet[r][0] = resets[r];
                resultSet[r][1] = upTime[r];
                if (returnType) {
                    resultSet[r][2] = type[r];
                }
                int k = 0;
                while (k < results[r].length) {
                    resultSet[r][k + offset] = "" + results[r][k];
                    ++k;
                }
                ++r;
            }
            String[][] stringArray = resultSet;
            return stringArray;
        }
        finally {
            this.deleteLock = false;
        }
    }

    synchronized double[][] getGraphData(String name, int period, Spacecraft id, int fromReset, long fromUptime, boolean positionData, boolean reverse) throws IOException {
        this.deleteLock = true;
        try {
            this.loadSegments(fromReset, fromUptime, period, reverse);
            int start = 0;
            int end = 0;
            int COLUMNS = 3;
            double[] lat = null;
            double[] lon = null;
            if (positionData) {
                COLUMNS = 5;
            }
            if (reverse) {
                start = this.rtRecords.size() - period;
                end = this.rtRecords.size();
            } else {
                start = this.rtRecords.getNearestFrameIndex(id.foxId, fromUptime, fromReset);
                if (start == -1) {
                    start = this.rtRecords.size() - period;
                }
                end = start + period;
            }
            if (end > this.rtRecords.size()) {
                end = this.rtRecords.size();
            }
            if (end < start) {
                end = start;
            }
            if (start < 0) {
                start = 0;
            }
            if (start > this.rtRecords.size()) {
                start = this.rtRecords.size();
            }
            double[] results = new double[end - start];
            double[] upTime = new double[end - start];
            double[] resets = new double[end - start];
            if (positionData) {
                lat = new double[end - start];
                lon = new double[end - start];
            }
            int j = results.length - 1;
            int i = end - 1;
            while (i >= start) {
                results[j] = Config.displayRawValues ? (double)((FramePart)this.rtRecords.get(i)).getRawValue(name) : ((FramePart)this.rtRecords.get(i)).getDoubleValue(name, id);
                if (positionData) {
                    lat[j] = ((FramePart)this.rtRecords.get((int)i)).satLatitude;
                    lon[j] = ((FramePart)this.rtRecords.get((int)i)).satLongitude;
                }
                upTime[j] = ((FramePart)this.rtRecords.get(i)).getUptime();
                resets[j--] = ((FramePart)this.rtRecords.get(i)).getResets();
                --i;
            }
            double[][] resultSet = new double[COLUMNS][end - start];
            resultSet[0] = results;
            resultSet[1] = upTime;
            resultSet[2] = resets;
            if (positionData) {
                resultSet[3] = lat;
                resultSet[4] = lon;
            }
            double[][] dArray = resultSet;
            return dArray;
        }
        finally {
            this.deleteLock = false;
        }
    }

    private TableSeg getSeg(int reset, long uptime, boolean prev) throws IOException {
        int i = this.tableIdx.size() - 1;
        while (i >= 0) {
            if (((TableSeg)this.tableIdx.get((int)i)).fromReset <= reset && ((TableSeg)this.tableIdx.get((int)i)).fromUptime <= uptime) {
                return (TableSeg)this.tableIdx.get(i);
            }
            if (prev && ((TableSeg)this.tableIdx.get((int)i)).fromReset < reset) {
                return (TableSeg)this.tableIdx.get(i);
            }
            --i;
        }
        if (prev) {
            return null;
        }
        TableSeg seg = new TableSeg(reset, uptime, this.baseFileName);
        this.tableIdx.add(seg);
        this.saveIdx();
        return seg;
    }

    private TableSeg loadSeg(int reset, long uptime, boolean prev) throws IOException {
        TableSeg seg = this.getSeg(reset, uptime, prev);
        if (seg == null) {
            return null;
        }
        seg.accessed();
        if (seg.isLoaded()) {
            return seg;
        }
        this.load(seg);
        return seg;
    }

    protected synchronized int getNumberOfPayloadsBetweenTimestamps(int reset, long uptime, int toReset, long toUptime) throws IOException {
        this.deleteLock = true;
        try {
            int end;
            int fromSeg = this.findFirstSeg(reset, uptime);
            int toSeg = this.findFirstSeg(toReset, toUptime);
            int number = 0;
            int i = fromSeg;
            while (i <= toSeg && i < this.tableIdx.size()) {
                if (!((TableSeg)this.tableIdx.get(i)).isLoaded()) {
                    this.load((TableSeg)this.tableIdx.get(i));
                }
                ++i;
            }
            int id = ((FramePart)this.rtRecords.get((int)0)).id;
            int start = this.rtRecords.getNearestFrameIndex(id, uptime, reset);
            if (start < (end = this.rtRecords.getNearestFrameIndex(id, toUptime, toReset))) {
                number = end - start;
            }
            int n = number;
            return n;
        }
        finally {
            this.deleteLock = false;
        }
    }

    private int findFirstSeg(int reset, long uptime) {
        boolean loadnow = false;
        int i = 0;
        while (i < this.tableIdx.size()) {
            if (!loadnow) {
                if (((TableSeg)this.tableIdx.get((int)i)).fromReset > reset) {
                    loadnow = true;
                }
                if (i == 0 && ((TableSeg)this.tableIdx.get((int)i)).fromReset == reset && ((TableSeg)this.tableIdx.get((int)i)).fromUptime > uptime) {
                    loadnow = true;
                }
                if (i < this.tableIdx.size() - 1 && ((TableSeg)this.tableIdx.get((int)i)).fromReset < reset && (((TableSeg)this.tableIdx.get((int)(i + 1))).fromReset > reset || ((TableSeg)this.tableIdx.get((int)(i + 1))).fromReset == reset && ((TableSeg)this.tableIdx.get((int)(i + 1))).fromUptime > uptime)) {
                    loadnow = true;
                }
                if (i < this.tableIdx.size() - 1 && ((TableSeg)this.tableIdx.get((int)i)).fromReset == reset && ((TableSeg)this.tableIdx.get((int)i)).fromUptime < uptime && (((TableSeg)this.tableIdx.get((int)(i + 1))).fromReset > reset || ((TableSeg)this.tableIdx.get((int)(i + 1))).fromReset == reset && ((TableSeg)this.tableIdx.get((int)(i + 1))).fromUptime > uptime)) {
                    loadnow = true;
                }
                if (i == this.tableIdx.size() - 1 && ((TableSeg)this.tableIdx.get((int)i)).fromReset <= reset) {
                    loadnow = true;
                }
            }
            if (loadnow) {
                return i;
            }
            ++i;
        }
        return -99;
    }

    private synchronized void loadSegments(int reset, long uptime, int number, boolean reverse) throws IOException {
        block12: {
            boolean existingLock = this.deleteLock;
            this.deleteLock = true;
            int total = 0;
            try {
                if (reverse) {
                    int startIdx = 0;
                    int i = this.tableIdx.size() - 1;
                    while (i >= 0) {
                        if ((total += ((TableSeg)this.tableIdx.get((int)i)).records) >= number) {
                            startIdx = i;
                            break;
                        }
                        --i;
                    }
                    total = 0;
                    i = startIdx;
                    while (i < this.tableIdx.size()) {
                        if (!((TableSeg)this.tableIdx.get(i)).isLoaded()) {
                            this.load((TableSeg)this.tableIdx.get(i));
                        } else {
                            ((TableSeg)this.tableIdx.get(i)).accessed();
                        }
                        total += ((TableSeg)this.tableIdx.get((int)i)).records;
                        ++i;
                    }
                    break block12;
                }
                int i = this.findFirstSeg(reset, uptime);
                if (i < 0) break block12;
                while (i < this.tableIdx.size()) {
                    if (!((TableSeg)this.tableIdx.get(i)).isLoaded()) {
                        this.load((TableSeg)this.tableIdx.get(i));
                    } else {
                        ((TableSeg)this.tableIdx.get(i)).accessed();
                    }
                    if ((total += ((TableSeg)this.tableIdx.get((int)i++)).records) < number + 1000) continue;
                    break;
                }
            }
            finally {
                this.deleteLock = existingLock;
            }
        }
    }

    public synchronized void offloadSegments() {
        while (this.deleteLock) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        boolean resized = false;
        for (TableSeg seg : this.tableIdx) {
            if (!seg.isStale()) continue;
            this.offloadSeg(seg);
            resized = true;
        }
        if (resized) {
            this.rtRecords.trimToSize();
        }
    }

    private void offloadSeg(TableSeg seg) {
        if (this.rtRecords == null || this.rtRecords.size() == 0) {
            return;
        }
        if (Config.debugSegs) {
            Log.println("Offloaded SEG: " + seg.toString());
        }
        boolean foundStart = false;
        int removePoint = 0;
        seg.setLoaded(false);
        int i = 0;
        while (i < this.rtRecords.size()) {
            FramePart f;
            if (!foundStart && (f = (FramePart)this.rtRecords.get(i)) != null && f.resets == seg.fromReset && f.uptime == seg.fromUptime) {
                foundStart = true;
                removePoint = i;
            }
            if (foundStart) {
                int j = 0;
                while (j < seg.records) {
                    int s = this.tableIdx.size() - 1;
                    while (s >= 0 && removePoint < this.rtRecords.size()) {
                        if (((TableSeg)this.tableIdx.get((int)s)).fromReset <= ((FramePart)this.rtRecords.get((int)removePoint)).resets && ((TableSeg)this.tableIdx.get((int)s)).fromUptime <= ((FramePart)this.rtRecords.get((int)removePoint)).uptime) {
                            if (((TableSeg)this.tableIdx.get(s)).equals(seg)) {
                                this.rtRecords.remove(removePoint);
                                break;
                            }
                            ++removePoint;
                            break;
                        }
                        --s;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public synchronized boolean save(FramePart f) throws IOException {
        this.deleteLock = true;
        try {
            TableSeg seg = this.loadSeg(f.resets, f.uptime, false);
            if (this.rtRecords.add(f)) {
                TableSeg newseg;
                boolean added;
                this.updated = true;
                if (seg.records == 1000 && (added = this.tableIdx.add(newseg = new TableSeg(f.resets, f.uptime, this.baseFileName)))) {
                    seg = newseg;
                }
                this.save(f, String.valueOf(SatPayloadTable.getDir()) + "FOXDB" + File.separator + seg.fileName);
                ++seg.records;
                this.saveIdx();
                return true;
            }
            if (Config.debugFieldValues) {
                Log.println("DUPLICATE (or corrupt) RECORD, not saved: " + f.resets + ":" + f.uptime + " Ty:" + f.type);
            }
            return false;
        }
        finally {
            this.deleteLock = false;
        }
    }

    public synchronized void load(TableSeg seg) throws IOException {
        String log = String.valueOf(SatPayloadTable.getDir()) + "FOXDB" + File.separator + seg.fileName;
        this.createNewFile(log);
        BufferedReader dis = new BufferedReader(new FileReader(log));
        this.deleteLock = true;
        try {
            try {
                String line;
                while ((line = dis.readLine()) != null) {
                    if (line == null) continue;
                    this.addLine(line);
                }
                seg.setLoaded(true);
                if (Config.debugSegs) {
                    Log.println("Loaded SEG: " + seg.toString());
                }
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                Log.println(e.getMessage());
                dis.close();
                this.deleteLock = false;
            }
            catch (NumberFormatException n) {
                n.printStackTrace(Log.getWriter());
                Log.println(n.getMessage());
                dis.close();
                this.deleteLock = false;
            }
        }
        finally {
            dis.close();
            this.deleteLock = false;
        }
    }

    private FramePart addLine(String line) {
        if (line.length() == 0) {
            return null;
        }
        String date = null;
        int id = 0;
        int resets = 0;
        long uptime = 0L;
        int type = 0;
        int mode = 0;
        StringTokenizer st = null;
        try {
            st = new StringTokenizer(line, ",");
            date = st.nextToken();
            id = Integer.valueOf(st.nextToken());
            resets = Integer.valueOf(st.nextToken());
            uptime = Long.valueOf(st.nextToken());
            type = Integer.valueOf(st.nextToken());
            if (this.storeMode) {
                mode = Integer.valueOf(st.nextToken());
            }
            if (Config.satManager.getSpacecraft(id) == null) {
                Log.errorDialog("FATAL", "Attempting to Load payloads from the Payload store for satellite with Fox Id: " + id + "\n when no sattellite with that FoxId is configured.  Add this spacecraft to the satellite directory and restart FoxTelem." + "\nProgram will now exit");
                System.exit(1);
            }
            FramePart rt = null;
            if (type == 17 || type >= 1700 && type < 1800) {
                int pktid3;
                int pktid2;
                int pktid1;
                int pktid;
                int canId;
                BitArrayLayout canLayout;
                String[] st2 = line.split(",");
                int canIdField = 5;
                if (this.storeMode) {
                    canIdField = 6;
                }
                if ((rt = new UwCanPacket(id, resets, uptime, date, st, canLayout = Config.satManager.getLayoutByCanId(id, canId = UwCanPacket.getIdFromRawBytes(pktid = Integer.valueOf(st2[canIdField]).intValue(), pktid1 = Integer.valueOf(st2[canIdField + 1]).intValue(), pktid2 = Integer.valueOf(st2[canIdField + 2]).intValue(), pktid3 = Integer.valueOf(st2[canIdField + 3]).intValue())))) != null) {
                    rt.type = type;
                }
            } else if (this.isFOXDB_V3) {
                rt = FramePart.makePayload(id, resets, uptime, date, st, this.layout);
                rt.type = type;
            } else {
                rt = FramePart.makeLegacyPayload(id, resets, uptime, date, st, type);
            }
            if (this.rtRecords != null && rt != null) {
                if (this.storeMode) {
                    rt.newMode = mode;
                }
                try {
                    this.rtRecords.add(rt);
                }
                catch (NullPointerException e) {
                    this.rtRecords.add(rt);
                }
            }
            return rt;
        }
        catch (NoSuchElementException e) {
            Log.errorDialog("ERROR: Corrupted record", " Could not load record. If this is test data \nuse File>Delete Payloads once FoxTelem has started.\nThis record will be ignored.");
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.errorDialog("ERROR: Too many fields: Index out of bounds", String.valueOf(e.getMessage()) + " Could not load line for SAT: " + id + " Reset:" + resets + " Up:" + uptime + " Type:" + type);
            return null;
        }
        catch (NumberFormatException n) {
            Log.println("ERROR: Invalid number:  " + n.getMessage() + " Could not load frame " + id + " " + resets + " " + uptime + " " + type);
            Log.errorDialog("LOAD ERROR - DEBUG MESSAGE", "ERROR: Invalid number:  " + n.getMessage() + " Could not load frame " + id + " " + resets + " " + uptime + " " + type);
            return null;
        }
    }

    public void convert() throws IOException {
        String log = String.valueOf(SatPayloadTable.getDir()) + this.baseFileName + ".log";
        int linesAdded = 0;
        TableSeg seg = null;
        File aFile = new File(log);
        if (aFile.exists()) {
            BufferedReader dis = new BufferedReader(new FileReader(log));
            try {
                String line;
                while ((line = dis.readLine()) != null) {
                    FramePart rt;
                    if (line == null || (rt = this.addLine(line)) == null) continue;
                    if (linesAdded == 1000) {
                        linesAdded = 0;
                    }
                    if (linesAdded == 0) {
                        seg = new TableSeg(rt.resets, rt.uptime, this.baseFileName);
                        this.tableIdx.add(seg);
                    }
                    this.save(rt, String.valueOf(SatPayloadTable.getDir()) + "FOXDB" + File.separator + seg.fileName);
                    seg.records = ++linesAdded;
                }
                this.updated = true;
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (NumberFormatException n) {
                n.printStackTrace(Log.getWriter());
            }
        }
        this.saveIdx();
    }

    private boolean createNewFile(String log) throws IOException {
        File aFile = new File(log);
        if (!aFile.exists()) {
            try {
                aFile.createNewFile();
                return true;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR creating file " + log, 0);
                e.printStackTrace(Log.getWriter());
                return false;
            }
        }
        return false;
    }

    private void writeVersion(Writer output) throws IOException {
    }

    private void save(FramePart f, String log) throws IOException {
        boolean appendNewLine = false;
        if (!this.createNewFile(log) && !SatPayloadTable.newLineExists(log)) {
            appendNewLine = true;
        }
        File aFile = new File(log);
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, true));
        try {
            if (appendNewLine) {
                output.write("\n");
            }
            output.write(String.valueOf(f.toFile(this.storeMode)) + "\n");
            ((Writer)output).flush();
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    public static boolean newLineExists(String log) throws IOException {
        File file = new File(log);
        RandomAccessFile fileHandler = new RandomAccessFile(file, "r");
        long fileLength = fileHandler.length() - 1L;
        if (fileLength < 0L) {
            fileHandler.close();
            return true;
        }
        fileHandler.seek(fileLength);
        byte readByte = fileHandler.readByte();
        fileHandler.close();
        return readByte == 10 || readByte == 13;
    }

    private void saveIdx() throws IOException {
        File aFile = new File(String.valueOf(this.fileName) + ".idx");
        this.createNewFile(String.valueOf(this.fileName) + ".idx");
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, false));
        this.writeVersion(output);
        try {
            for (TableSeg seg : this.tableIdx) {
                output.write(String.valueOf(seg.toFile()) + "\n");
                ((Writer)output).flush();
            }
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    private void parseVersion(BufferedReader dis) throws IOException {
    }

    public void loadIdx() throws IOException {
        File aFile = new File(String.valueOf(this.fileName) + ".idx");
        if (this.createNewFile(String.valueOf(this.fileName) + ".idx")) {
            BufferedWriter output = new BufferedWriter(new FileWriter(aFile, true));
            this.writeVersion(output);
            ((Writer)output).close();
        }
        try (BufferedReader dis = new BufferedReader(new FileReader(aFile.getPath()));){
            try {
                String line;
                this.parseVersion(dis);
                while ((line = dis.readLine()) != null) {
                    if (line == null) continue;
                    StringTokenizer st = new StringTokenizer(line, ",");
                    int resets = Integer.valueOf(st.nextToken());
                    long uptime = Long.valueOf(st.nextToken());
                    int records = Integer.valueOf(st.nextToken());
                    String name = st.nextToken();
                    TableSeg seg = new TableSeg(resets, uptime, name, records);
                    this.tableIdx.add(seg);
                }
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                dis.close();
            }
            catch (NumberFormatException n) {
                n.printStackTrace(Log.getWriter());
                dis.close();
            }
        }
    }

    public void remove() throws IOException {
        for (TableSeg seg : this.tableIdx) {
            SatPayloadStore.remove(String.valueOf(SatPayloadTable.getDir()) + "FOXDB" + File.separator + seg.fileName);
        }
        SatPayloadStore.remove(String.valueOf(this.fileName) + ".idx");
    }
}

