/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import gui.MainWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.ConcurrentLinkedQueue;
import telemetry.Format.FormatFrame;
import telemetry.frames.Frame;
import telemetry.frames.HighSpeedFrame;
import telemetry.frames.SlowSpeedFrame;

public abstract class RawQueue
implements Runnable {
    ConcurrentLinkedQueue<Frame> rawSlowSpeedFrames;
    ConcurrentLinkedQueue<Frame> rawHighSpeedFrames;
    ConcurrentLinkedQueue<Frame> formatFrames;
    protected boolean updatedSlowQueue = false;
    protected boolean updatedHSQueue = false;
    protected boolean updatedPSKQueue = false;
    boolean running = false;

    RawQueue() {
    }

    public abstract boolean add(Frame var1) throws IOException;

    public abstract void delete();

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void load(String log, int type) throws IOException {
        block6: {
            block5: {
                if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                    log = String.valueOf(Config.logFileDirectory) + File.separator + log;
                    Log.println("Loading: " + log);
                }
                if (!(aFile = new File(log)).exists()) {
                    aFile.createNewFile();
                }
                dis = new FileInputStream(log);
                reader = new BufferedReader(new InputStreamReader(dis));
                frame /* !! */  = null;
                if (type != 0) break block5;
                while (reader.ready()) {
                    frame /* !! */  = new SlowSpeedFrame(reader);
                    this.rawSlowSpeedFrames.add(frame /* !! */ );
                }
                this.updatedSlowQueue = true;
                break block6;
            }
            if (type != 1) ** GOTO lbl30
            while (reader.ready()) {
                frame /* !! */  = new HighSpeedFrame(reader);
                this.rawHighSpeedFrames.add(frame /* !! */ );
            }
            this.updatedHSQueue = true;
            break block6;
lbl-1000:
            // 1 sources

            {
                frame /* !! */  = new FormatFrame(reader);
                this.formatFrames.add(frame /* !! */ );
lbl30:
                // 2 sources

                ** while (reader.ready())
            }
lbl31:
            // 1 sources

            this.updatedPSKQueue = true;
        }
        dis.close();
        MainWindow.setTotalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(Frame frame, String log) throws IOException {
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
        }
        RawQueue rawQueue = this;
        synchronized (rawQueue) {
            File aFile = new File(log);
            if (!aFile.exists()) {
                aFile.createNewFile();
            }
            FileOutputStream dis = new FileOutputStream(log, true);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dis));
            try {
                frame.save(writer);
            }
            finally {
                writer.flush();
                writer.close();
            }
            writer.close();
            dis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteAndSave(ConcurrentLinkedQueue<Frame> frames, String log) throws IOException {
        RawQueue rawQueue = this;
        synchronized (rawQueue) {
            File aFile;
            frames.poll();
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                log = String.valueOf(Config.logFileDirectory) + File.separator + log;
            }
            if (!(aFile = new File(log)).exists()) {
                aFile.createNewFile();
            }
            FileOutputStream dis = new FileOutputStream(log, false);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dis));
            try {
                for (Frame f : frames) {
                    f.save(writer);
                }
            }
            finally {
                writer.flush();
                writer.close();
            }
        }
    }

    public void stopProcessing() {
        this.running = false;
    }
}

