/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.TlmServer;
import gui.MainWindow;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JOptionPane;
import measure.PassMeasurement;
import telemetry.Format.FormatFrame;
import telemetry.RawQueue;
import telemetry.SatPayloadStore;
import telemetry.SatPayloadTable;
import telemetry.frames.Frame;
import telemetry.frames.SlowSpeedFrame;

public class RawFrameQueue
extends RawQueue {
    public static String RAW_SLOW_SPEED_FRAMES_FILE = "rawDUVframes.log";
    public static String RAW_HIGH_SPEED_FRAMES_FILE = "rawHSframes.log";
    public static String RAW_PSK_FRAMES_FILE = "rawPSKframes.log";
    TlmServer primaryServer;
    TlmServer secondaryServer;

    public RawFrameQueue() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.primaryServer = new TlmServer(Config.primaryServer, Config.serverPort, true, true);
        this.secondaryServer = new TlmServer(Config.secondaryServer, Config.serverPort, true, true);
        this.rawSlowSpeedFrames = new ConcurrentLinkedQueue();
        this.rawHighSpeedFrames = new ConcurrentLinkedQueue();
        this.formatFrames = new ConcurrentLinkedQueue();
        try {
            RawFrameQueue rawFrameQueue = this;
            synchronized (rawFrameQueue) {
                this.load(RAW_SLOW_SPEED_FRAMES_FILE, 0);
                this.load(RAW_HIGH_SPEED_FRAMES_FILE, 1);
                this.load(RAW_PSK_FRAMES_FILE, 2);
            }
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR Raw Frames Queue File not found", 0);
            e.printStackTrace(Log.getWriter());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "I/O ERROR Loading Stored Raw Frames Queue", 0);
            e.printStackTrace(Log.getWriter());
        }
    }

    @Override
    public boolean add(Frame f) throws IOException {
        if (f instanceof SlowSpeedFrame) {
            this.updatedSlowQueue = true;
            this.save(f, RAW_SLOW_SPEED_FRAMES_FILE);
            MainWindow.setTotalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
            return this.rawSlowSpeedFrames.add(f);
        }
        if (f instanceof FormatFrame) {
            this.updatedPSKQueue = true;
            this.save(f, RAW_PSK_FRAMES_FILE);
            MainWindow.setTotalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
            return this.formatFrames.add(f);
        }
        this.updatedHSQueue = true;
        this.save(f, RAW_HIGH_SPEED_FRAMES_FILE);
        MainWindow.setTotalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
        return this.rawHighSpeedFrames.add(f);
    }

    @Override
    public void delete() {
        try {
            SatPayloadStore.remove(String.valueOf(SatPayloadTable.getDir()) + RAW_SLOW_SPEED_FRAMES_FILE);
            SatPayloadStore.remove(String.valueOf(SatPayloadTable.getDir()) + RAW_HIGH_SPEED_FRAMES_FILE);
            SatPayloadStore.remove(String.valueOf(SatPayloadTable.getDir()) + RAW_PSK_FRAMES_FILE);
            this.init();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting Server Upload Queues, check permissions on files:\n" + RAW_SLOW_SPEED_FRAMES_FILE + "\n" + RAW_PSK_FRAMES_FILE + "\n" + RAW_HIGH_SPEED_FRAMES_FILE, 0);
        }
    }

    @Override
    public void run() {
        this.running = true;
        boolean success = true;
        int retryStep = 0;
        while (this.running) {
            try {
                Thread.sleep(100 * Config.serverTxPeriod);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: server frame queue thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            MainWindow.setTotalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
            if (!Config.uploadToServer) continue;
            if (!success && retryStep++ > Config.serverRetryWaitPeriod) {
                success = true;
                retryStep = 0;
            }
            if (this.rawSlowSpeedFrames.size() > 0 && success) {
                if (!Config.passManager.inPass() || Config.passManager.inPass() && this.rawSlowSpeedFrames.size() > 1) {
                    success = this.sendFrame(this.rawSlowSpeedFrames, RAW_SLOW_SPEED_FRAMES_FILE);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Log.println("ERROR: server DUV frame queue thread interrupted");
                    e.printStackTrace(Log.getWriter());
                }
            }
            if (this.rawHighSpeedFrames.size() > 0 && success) {
                if (!Config.passManager.inPass() || Config.passManager.inPass() && this.rawHighSpeedFrames.size() > 1) {
                    success = this.sendFrame(this.rawHighSpeedFrames, RAW_HIGH_SPEED_FRAMES_FILE);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Log.println("ERROR: server HS frame queue thread interrupted");
                    e.printStackTrace(Log.getWriter());
                }
            }
            if (this.formatFrames.size() <= 0 || !success) continue;
            if (!Config.passManager.inPass() || Config.passManager.inPass() && this.formatFrames.size() > 1) {
                success = this.sendFrame(this.formatFrames, RAW_PSK_FRAMES_FILE);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: server PSK frame queue thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
        }
        Log.println("Server Queue thread ended");
    }

    private boolean sendFrame(ConcurrentLinkedQueue<Frame> frames, String file) {
        byte[] buffer;
        boolean success = false;
        if (Config.passManager.hasTCA()) {
            PassMeasurement passMeasurement = Config.passManager.getPassMeasurement();
            if (frames.peek() != null) {
                frames.peek().setPassMeasurement(passMeasurement);
                Config.passManager.sentTCA();
            }
        }
        this.primaryServer.setHostName(Config.primaryServer);
        this.secondaryServer.setHostName(Config.secondaryServer);
        String protocol = "udp";
        if (Config.serverProtocol == 0) {
            protocol = "tcp";
        }
        Log.println("Trying Primary Server: " + protocol + "://" + Config.primaryServer + ":" + Config.serverPort);
        try {
            if (frames.peek() != null) {
                buffer = frames.peek().getServerBytes();
                success = this.primaryServer.sendToServer(buffer, Config.serverProtocol);
            }
        }
        catch (UnknownHostException e) {
            Log.println("Could not connect to primary server:" + e.getMessage());
        }
        catch (IOException e) {
            Log.println("IO Exception with primary server: " + e.getMessage());
        }
        if (this.running && (Config.sendToBothServers || !success)) {
            try {
                Log.println("Trying Secondary Server: " + protocol + "://" + Config.secondaryServer + ":" + Config.serverPort);
                if (frames.peek() != null) {
                    buffer = frames.peek().getServerBytes();
                    success = this.secondaryServer.sendToServer(buffer, Config.serverProtocol);
                }
            }
            catch (UnknownHostException e) {
                Log.println("Could not connect to secondary server: " + e.getMessage());
            }
            catch (IOException e) {
                Log.println("IO Exception with secondary server: " + e.getMessage());
            }
        }
        if (success) {
            try {
                this.deleteAndSave(frames, file);
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not remove raw frames from the queue file:\n" + file + "\n" + " The frame will be sent again.  If this error repeats you may need to remove the queue file manually");
                e.printStackTrace(Log.getWriter());
            }
        }
        MainWindow.setTotalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
        return success;
    }
}

