/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.ProgressPanel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import measure.Measurement;
import measure.PassMeasurement;
import measure.RtMeasurement;
import measure.SatMeasurementStore;
import measure.SortedMeasurementArrayList;
import telemetry.FoxPayloadStore;
import telemetry.FramePart;
import telemetry.SatPayloadStore;
import telemetry.SatPictureStore;
import telemetry.SortedFramePartArrayList;
import telemetry.SortedJpegList;
import telemetry.frames.Frame;
import telemetry.herci.HerciHighspeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.legacyPayloads.PayloadCameraData;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.legacyPayloads.PictureScanLine;
import telemetry.legacyPayloads.RadiationTelemetry;
import telemetry.mesat.MesatImageStore;

public class PayloadStore
extends FoxPayloadStore
implements Runnable {
    public static final String DB_NAME = "FOXDB";
    public static final String RAW_DIR_NAME = "raw";
    public static final String DB_VERSION = "1.00";
    public static final int DATA_COL = 0;
    public static final int UPTIME_COL = 1;
    public static final int RESETS_COL = 2;
    public static final int LAT_COL = 3;
    public static final int LON_COL = 4;
    private boolean running = true;
    private boolean done = false;
    private SortedFramePartArrayList payloadQueue = new SortedFramePartArrayList(1000);
    private SortedMeasurementArrayList measurementQueue = new SortedMeasurementArrayList(1000);
    private final int INITIAL_QUEUE_SIZE = 1000;
    SatPayloadStore[] payloadStore;
    SatPictureStore[] pictureStore;
    SatMeasurementStore[] measurementStore;

    public PayloadStore() {
        ArrayList<Spacecraft> sats = Config.satManager.getSpacecraftList();
        this.payloadStore = new SatPayloadStore[sats.size()];
        this.pictureStore = new SatPictureStore[sats.size()];
        this.measurementStore = new SatMeasurementStore[sats.size()];
        String dir = "";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator;
        }
        String loadMessage = "FoxTelem: Loading logged data, please wait ...";
        boolean newDB = this.makeDir(String.valueOf(dir) + DB_NAME);
        if (newDB) {
            File aFile;
            String testFile = "Fox1rtTelemetry.log";
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                testFile = String.valueOf(Config.logFileDirectory) + File.separator + testFile;
            }
            if ((aFile = new File(testFile)).exists()) {
                Log.infoDialog("Database Conversion", "You have pre version 1.03 payload log files.  These will be converted to the new 1.03 database format.\nThis process may take a few minutes to load the data and convert it\n");
                loadMessage = "FoxTelem: Database conversion in progress, please wait ...";
            } else {
                newDB = false;
            }
        }
        this.makeDir(String.valueOf(dir) + RAW_DIR_NAME);
        if (Log.showGuiDialogs) {
            Config.fileProgress = new ProgressPanel(MainWindow.frame, loadMessage, false);
            Config.fileProgress.setVisible(true);
        }
        int s = 0;
        while (s < sats.size()) {
            this.payloadStore[s] = new SatPayloadStore(sats.get((int)s).foxId);
            if (newDB) {
                try {
                    this.payloadStore[s].convert();
                }
                catch (IOException e) {
                    Log.errorDialog("ERROR", "Could not convert the old FoxTelem payload files to the new format: \nAny old payloads will not be available\n");
                    e.printStackTrace(Log.getWriter());
                }
            }
            if (sats.get(s).hasCamera()) {
                this.pictureStore[s] = new SatPictureStore(sats.get((int)s).foxId);
            }
            if (sats.get(s).hasMesatCamera()) {
                this.mesatImageStore = new MesatImageStore(sats.get((int)s).foxId);
            }
            this.measurementStore[s] = new SatMeasurementStore(sats.get((int)s).foxId);
            if (Log.showGuiDialogs) {
                Config.fileProgress.updateProgress(100 * s / sats.size());
            }
            ++s;
        }
        this.loaded = true;
    }

    private boolean makeDir(String dir) {
        File aFile = new File(dir);
        if (!aFile.isDirectory()) {
            Log.println("Making new database: " + dir);
            aFile.mkdir();
            if (!aFile.isDirectory()) {
                Log.errorDialog("ERROR", "ERROR can't create the directory: " + aFile.getAbsolutePath() + "\nAny decoded payloads will not be saved to disk\n");
                Config.storePayloads = false;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasQueuedFrames() {
        return this.payloadQueue.size() > 0;
    }

    @Override
    public int getQueuedFramesSize() {
        return this.payloadQueue.size();
    }

    @Override
    public boolean hasQueuedMeasurements() {
        return this.measurementQueue.size() > 0;
    }

    private SatPayloadStore getPayloadStoreById(int id) {
        SatPayloadStore[] satPayloadStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadStore store = satPayloadStoreArray[n2];
            if (store != null && store.foxId == id) {
                return store;
            }
            ++n2;
        }
        return null;
    }

    private SatPictureStore getPictureStoreById(int id) {
        SatPictureStore[] satPictureStoreArray = this.pictureStore;
        int n = this.pictureStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPictureStore store = satPictureStoreArray[n2];
            if (store != null && store.foxId == id) {
                return store;
            }
            ++n2;
        }
        return null;
    }

    private SatMeasurementStore getMeasurementStoreById(int id) {
        SatMeasurementStore[] satMeasurementStoreArray = this.measurementStore;
        int n = this.measurementStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatMeasurementStore store = satMeasurementStoreArray[n2];
            if (store != null && store.foxId == id) {
                return store;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setUpdatedAll() {
        Object store;
        Object[] objectArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null) {
                ((SatPayloadStore)store).setUpdatedAll();
            }
            ++n2;
        }
        objectArray = this.pictureStore;
        n = this.pictureStore.length;
        n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null) {
                ((SatPictureStore)store).setUpdatedAll();
            }
            ++n2;
        }
        objectArray = this.measurementStore;
        n = this.measurementStore.length;
        n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null) {
                ((SatMeasurementStore)store).setUpdatedAll();
            }
            ++n2;
        }
    }

    @Override
    public void setUpdatedAll(int id) {
        SatMeasurementStore mStore;
        SatPictureStore picstore;
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdatedAll();
        }
        if ((picstore = this.getPictureStoreById(id)) != null) {
            picstore.setUpdatedAll();
        }
        if ((mStore = this.getMeasurementStoreById(id)) != null) {
            mStore.setUpdatedAll();
        }
    }

    @Override
    public boolean getUpdated(int id, String lay) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getUpdated(lay);
        }
        return false;
    }

    @Override
    public void setUpdated(int id, String lay, boolean u) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdated(lay, u);
        }
    }

    @Override
    public boolean getUpdatedCamera(int id) {
        SatPictureStore store = this.getPictureStoreById(id);
        if (store != null) {
            return store.getUpdatedCamera();
        }
        return false;
    }

    @Override
    public void setUpdatedCamera(int id, boolean u) {
        SatPictureStore store = this.getPictureStoreById(id);
        if (store != null) {
            store.setUpdatedCamera(u);
        }
    }

    @Override
    public boolean getUpdatedMeasurement(int id) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            return store.getUpdatedMeasurement();
        }
        return false;
    }

    @Override
    public void setUpdatedMeasurement(int id, boolean u) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            store.setUpdatedMeasurement(u);
        }
    }

    @Override
    public boolean getUpdatedPassMeasurement(int id) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            return store.getUpdatedPassMeasurement();
        }
        return false;
    }

    @Override
    public void setUpdatedPassMeasurement(int id, boolean u) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            store.setUpdatedPassMeasurement(u);
        }
    }

    @Override
    public int getTotalNumberOfFrames() {
        int total = 0;
        SatPayloadStore[] satPayloadStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadStore store = satPayloadStoreArray[n2];
            total += store.getNumberOfFrames();
            ++n2;
        }
        return total;
    }

    @Override
    public int getTotalNumberOfFrames(String lay) {
        int total = 0;
        SatPayloadStore[] satPayloadStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadStore store = satPayloadStoreArray[n2];
            total += store.getNumberOfFrames(lay);
            ++n2;
        }
        return total;
    }

    public int getNumberOfFrames(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getNumberOfFrames();
        }
        return 0;
    }

    @Override
    public int getNumberOfFrames(int id, String lay) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getNumberOfFrames(lay);
        }
        return 0;
    }

    @Override
    public int getNumberOfTelemFrames(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getNumberOfTelemFrames();
        }
        return 0;
    }

    @Override
    public SortedFramePartArrayList getFrameParts(int id, int fromReset, long fromUptime, int period, boolean reverse, String layout) throws IOException {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getFrameParts(fromReset, fromUptime, period, reverse, layout);
        }
        return null;
    }

    @Override
    public int getNumberOfPictureCounters(int id) {
        SatPictureStore store = this.getPictureStoreById(id);
        if (store != null) {
            return store.getNumberOfPictureCounters();
        }
        return 0;
    }

    @Override
    public SortedJpegList getJpegIndex(int id, int period, int fromReset, long fromUptime) {
        SatPictureStore store = this.getPictureStoreById(id);
        if (store != null) {
            return store.getJpegIndex(id, period, fromReset, fromUptime);
        }
        return null;
    }

    @Override
    public boolean add(int id, long uptime, int resets, FramePart f) {
        f.captureHeaderInfo(id, uptime, resets);
        return this.payloadQueue.addToEnd(f);
    }

    @Override
    public boolean addToFile(int id, long uptime, int resets, FramePart f) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.add(id, uptime, resets, f);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (Exception e) {
                Log.errorDialog("ERROR", "Could not parse and save frame for sat: " + id + " reset: " + resets + " uptime: " + uptime + " type: " + f.type + "\nCheck if the correct frame layouts are being used for this spacecraft" + "\nError details:\n" + e);
            }
        }
        return false;
    }

    @Override
    public boolean add(int id, long uptime, int resets, PayloadRadExpData[] f) {
        int i = 0;
        while (i < f.length) {
            if (f[i].hasData()) {
                f[i].captureHeaderInfo(id, uptime, resets);
                f[i].type = 400 + i;
                this.payloadQueue.addToEnd(f[i]);
            }
            ++i;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean add(int id, long uptime, int resets, PayloadHERCIhighSpeed[] herci) {
        int i = 0;
        while (i < herci.length) {
            herci[i].captureHeaderInfo(id, uptime, resets);
            herci[i].type = 600 + i;
            this.payloadQueue.addToEnd(herci[i]);
            ++i;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean addToFile(int id, long uptime, int resets, PayloadRadExpData[] f) throws IOException {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.add(id, uptime, resets, f);
        }
        return false;
    }

    @Override
    public boolean addToPictureFile(int id, long uptime, int resets, PayloadCameraData f) {
        SatPictureStore store = this.getPictureStoreById(id);
        if (store != null) {
            ArrayList<PictureScanLine> lines = f.pictureLines;
            for (PictureScanLine line : lines) {
                line.id = id;
                line.resets = resets;
                line.uptime = uptime;
                try {
                    if (store.add(id, resets, uptime, line)) continue;
                    return false;
                }
                catch (IOException e) {
                    Log.println("File Error writting CAMERA DATA, line not written: " + id + " " + resets + " " + uptime + "\n" + e.getMessage());
                    e.printStackTrace(Log.getWriter());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.println("CORRUPT CAMERA DATA, line not written: " + id + " " + resets + " " + uptime);
                    e.printStackTrace(Log.getWriter());
                }
            }
        }
        return true;
    }

    @Override
    public boolean add(int id, RtMeasurement m) {
        return this.measurementQueue.addToEnd(m);
    }

    @Override
    public boolean addToFile(int id, Measurement m) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            try {
                return store.add(id, m);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return false;
    }

    @Override
    public int getNumberOfMeasurements(int id) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            return store.getNumberOfMeasurements();
        }
        return 0;
    }

    @Override
    public int getNumberOfPassMeasurements(int id) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            return store.getNumberOfPassMeasurements();
        }
        return 0;
    }

    @Override
    public RtMeasurement getLatestMeasurement(int id) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            return store.getLatestMeasurement();
        }
        return null;
    }

    @Override
    public boolean add(int id, PassMeasurement m) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            try {
                return store.add(id, m);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return false;
    }

    @Override
    public PassMeasurement getLatestPassMeasurement(int id) {
        SatMeasurementStore store = this.getMeasurementStoreById(id);
        if (store != null) {
            return store.getLatestPassMeasurement();
        }
        return null;
    }

    @Override
    public FramePart getFramePart(int id, int reset, long uptime, String layout, boolean prev) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatest(id, reset, uptime, layout, prev);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public FramePart getFramePart(int id, int reset, long uptime, int type, String layout, boolean prev) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatest(id, reset, uptime, type, layout, prev);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public FramePart getLatest(int id, String lay) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatest(lay);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public FramePart getLatestRt(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestRt();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public FramePart getLatestMax(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestMax();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public FramePart getLatestMin(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestMin();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public FramePart getLatestRad(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestRad();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public RadiationTelemetry getLatestRadTelem(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestRadTelem();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public RadiationTelemetry getRadTelem(int id, int resets, long uptime) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getRadTelem(id, resets, uptime);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public PayloadHERCIhighSpeed getLatestHerci(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestHerci();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public HerciHighspeedHeader getLatestHerciHeader(int id) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestHerciHeader();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public double[][] getGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, String layout, boolean positionData, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getGraphData(name, period, fox, fromReset, fromUptime, layout, positionData, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                Log.println("ERROR getting graph data: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public double[][] getRtGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean positionData, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getRtGraphData(name, period, fox, fromReset, fromUptime, positionData, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public double[][] getMaxGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean positionData, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getMaxGraphData(name, period, fox, fromReset, fromUptime, positionData, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public double[][] getMinGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean positionData, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getMinGraphData(name, period, fox, fromReset, fromUptime, positionData, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public String[][] getRtData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getRtData(period, id, fromReset, fromUptime, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public String[][] getWODData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getWODData(period, id, fromReset, fromUptime, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public String[][] getTableData(int period, int id, int fromReset, long fromUptime, boolean reverse, String layout) {
        return this.getTableData(period, id, fromReset, fromUptime, false, reverse, layout);
    }

    @Override
    public String[][] getTableData(int period, int id, int fromReset, long fromUptime, boolean returnType, boolean reverse, String layout) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getTableData(period, id, fromReset, fromUptime, returnType, reverse, layout);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String[][] getRadData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getRadData(period, id, fromReset, fromUptime, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String[][] getWODRadData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getWODRadData(period, id, fromReset, fromUptime, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String[][] getWodRadTelemData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getWodRadTelemData(period, id, fromReset, fromUptime, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String[][] getRadTelemData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getRadTelemData(period, id, fromReset, fromUptime, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String[][] getHerciPacketData(int period, int id, int fromReset, long fromUptime, boolean type, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getHerciPacketData(period, id, fromReset, fromUptime, type, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String[][] getHerciHsData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getHerciHsData(period, id, fromReset, fromUptime, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public double[][] getRadTelemGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean positionData, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getRadTelemGraphData(name, period, fox, fromReset, fromUptime, positionData, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public double[][] getHerciScienceHeaderGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean positionData, boolean reverse) {
        SatPayloadStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getHerciScienceHeaderGraphData(name, period, fox, fromReset, fromUptime, positionData, reverse);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public double[][] getMeasurementGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean reverse) {
        SatMeasurementStore store = this.getMeasurementStoreById(fox.foxId);
        if (store != null) {
            return store.getMeasurementGraphData(name, period, fox, fromReset, fromUptime, reverse);
        }
        return null;
    }

    @Override
    public void deleteAll() {
        Object store;
        this.loaded = false;
        Object[] objectArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null) {
                ((SatPayloadStore)store).deleteAll();
            }
            ++n2;
        }
        objectArray = this.pictureStore;
        n = this.pictureStore.length;
        n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null) {
                ((SatPictureStore)store).deleteAll();
            }
            ++n2;
        }
        objectArray = this.measurementStore;
        n = this.measurementStore.length;
        n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null) {
                ((SatMeasurementStore)store).deleteAll();
            }
            ++n2;
        }
        if (this.mesatImageStore != null) {
            this.mesatImageStore.deleteAll();
        }
        this.loaded = true;
    }

    @Override
    public void delete(Spacecraft sat) {
        Object store;
        this.loaded = false;
        Object[] objectArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null && ((SatPayloadStore)store).foxId == sat.foxId) {
                ((SatPayloadStore)store).deleteAll();
            }
            ++n2;
        }
        objectArray = this.pictureStore;
        n = this.pictureStore.length;
        n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null && ((SatPictureStore)store).foxId == sat.foxId) {
                ((SatPictureStore)store).deleteAll();
            }
            ++n2;
        }
        objectArray = this.measurementStore;
        n = this.measurementStore.length;
        n2 = 0;
        while (n2 < n) {
            store = objectArray[n2];
            if (store != null && ((SatMeasurementStore)store).foxId == sat.foxId) {
                ((SatMeasurementStore)store).deleteAll();
            }
            ++n2;
        }
        if (sat.hasMesatCamera() && this.mesatImageStore != null) {
            this.mesatImageStore.deleteAll();
        }
        this.loaded = true;
    }

    public void offloadSegments() {
        SatPayloadStore[] satPayloadStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadStore store = satPayloadStoreArray[n2];
            if (store != null) {
                store.offloadSegments();
            }
            ++n2;
        }
    }

    @Override
    public void run() {
        this.running = true;
        this.done = false;
        while (this.running) {
            Comparable<FramePart> f;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: PayloadStore thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            this.offloadSegments();
            if (!this.initialized()) continue;
            if (this.payloadQueue.size() > 0) {
                while (this.payloadQueue.size() > 0) {
                    f = (FramePart)this.payloadQueue.get(0);
                    if (f == null) {
                        Log.println("NULL RECORD IN THE Q");
                    } else {
                        if (Config.debugFieldValues) {
                            Log.println(String.valueOf(((FramePart)f).toString()) + "\n");
                        }
                        if (f instanceof PayloadCameraData) {
                            this.addToPictureFile(((FramePart)f).id, ((FramePart)f).uptime, ((FramePart)f).resets, (PayloadCameraData)f);
                        } else {
                            this.addToFile(((FramePart)f).id, ((FramePart)f).uptime, ((FramePart)f).resets, (FramePart)f);
                        }
                    }
                    this.payloadQueue.remove(0);
                    Thread.yield();
                }
            }
            if (this.measurementQueue.size() <= 0) continue;
            while (this.measurementQueue.size() > 0) {
                f = (Measurement)this.measurementQueue.get(0);
                if (f == null) {
                    Log.println("NULL RECORD IN THE MEASUREMENT Q");
                    continue;
                }
                if (Config.debugFieldValues) {
                    Log.println(String.valueOf(f.toString()) + "\n");
                }
                this.addToFile(((Measurement)f).id, (Measurement)f);
                this.measurementQueue.remove(0);
                Thread.yield();
            }
        }
        this.done = true;
    }

    @Override
    public void initRad2() {
    }

    @Override
    public void initHerciPackets() {
    }

    @Override
    public boolean addStpHeader(Frame f) {
        return false;
    }

    @Override
    public boolean updateStpHeader(Frame f) {
        return false;
    }

    @Override
    public String getRtUTCFromUptime(int id, int reset, long uptime) {
        return null;
    }

    @Override
    public boolean processNewImageLines() {
        return false;
    }

    @Override
    public double[][] getPassMeasurementGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean reverse) {
        SatMeasurementStore store = this.getMeasurementStoreById(fox.foxId);
        if (store != null) {
            return store.getPassMeasurementGraphData(name, period, fox, fromReset, fromUptime, reverse);
        }
        return null;
    }

    @Override
    public int getNumberOfPayloadsBetweenTimestamps(int id, int reset, long uptime, int toReset, long toUptime, String payloadType) {
        Object store;
        if ((payloadType == "measurements" || payloadType == "passmeasurements") && (store = this.getMeasurementStoreById(id)) != null) {
            return ((SatMeasurementStore)store).getNumberOfPayloadsBetweenTimestamps(id, reset, uptime, toReset, toUptime, payloadType);
        }
        store = this.getPayloadStoreById(id);
        if (store != null) {
            return ((SatPayloadStore)store).getNumberOfPayloadsBetweenTimestamps(id, reset, uptime, toReset, toUptime, payloadType);
        }
        return 0;
    }

    @Override
    public int checkForNewReset(int id, long uptime, Date stpDate, int resetOnFrame, String groundStation) {
        return 0;
    }
}

