/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.DescriptorUtils;
import org.usb4java.Interface;

public final class ConfigDescriptor {
    private long configDescriptorPointer;

    public long getPointer() {
        return this.configDescriptorPointer;
    }

    public native byte bLength();

    public native byte bDescriptorType();

    public native short wTotalLength();

    public native byte bNumInterfaces();

    public native byte bConfigurationValue();

    public native byte iConfiguration();

    public native byte bmAttributes();

    public native byte bMaxPower();

    public native Interface[] iface();

    public native ByteBuffer extra();

    public native int extraLength();

    public String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s  extralen %17d%n  extra:%n%s", DescriptorUtils.dump(this), this.extraLength(), DescriptorUtils.dump(this.extra()).replaceAll("(?m)^", "    ")));
        for (Interface iface : this.iface()) {
            builder.append(String.format("%n", new Object[0]) + iface.dump());
        }
        return builder.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.wTotalLength()).append(this.bNumInterfaces()).append(this.bConfigurationValue()).append(this.iConfiguration()).append(this.bmAttributes()).append(this.bMaxPower()).append(this.iface()).append(this.extra()).append(this.extraLength()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigDescriptor other = (ConfigDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.wTotalLength(), other.wTotalLength()).append(this.bNumInterfaces(), other.bNumInterfaces()).append(this.bConfigurationValue(), other.bConfigurationValue()).append(this.iConfiguration(), other.iConfiguration()).append(this.bmAttributes(), other.bmAttributes()).append(this.bMaxPower(), other.bMaxPower()).append(this.iface(), other.iface()).append(this.extra(), other.extra()).append(this.extraLength(), other.extraLength()).isEquals();
    }

    public String toString() {
        return this.dump();
    }
}

