/*
 * Decompiled with CFR 0.152.
 */
package measure;

import java.util.Date;
import telemetry.BitArrayLayout;
import telemetry.FramePart;

public abstract class Measurement
implements Comparable<Measurement> {
    public static final int INVALID_ERRORS = 999;
    Date date;
    public int id;
    int type;
    int reset;
    long uptime;
    public double[] fieldValue = null;
    protected BitArrayLayout layout;

    public int getReset() {
        return this.reset;
    }

    public long getUptime() {
        return this.uptime;
    }

    public Date getCaptureDate() {
        return this.date;
    }

    @Override
    public int compareTo(Measurement p) {
        if (this.date != null && p.date != null) {
            return this.date.compareTo(p.date);
        }
        return -1;
    }

    public String toFile() {
        String s = new String();
        String captureDate = FramePart.fileDateFormat.format(this.date);
        s = String.valueOf(s) + captureDate + "," + this.id + "," + this.reset + "," + this.uptime + "," + this.type + ",";
        int i = 0;
        while (i < this.layout.NUMBER_OF_FIELDS - 1) {
            s = String.valueOf(s) + this.fieldValue[i] + ",";
            ++i;
        }
        s = String.valueOf(s) + this.fieldValue[this.layout.NUMBER_OF_FIELDS - 1];
        return s;
    }
}

