/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import gui.tabs.ExperimentLayoutTableModel;
import gui.tabs.ModuleTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public abstract class ExperimentTab
extends ModuleTab
implements MouseListener {
    protected JPanel topPanel;
    protected JPanel centerPanel;
    protected JTable table;
    protected JTable table2;
    protected JScrollPane scrollPane2;
    protected JScrollPane scrollPane;
    protected JCheckBox showRawBytes;
    protected int splitPaneHeight = 0;
    protected JSplitPane splitPane;
    public static final int NO_ROW_SELECTED = -1;

    protected ExperimentTab() {
        this.setLayout(new BorderLayout(0, 0));
        this.topPanel = new JPanel();
        this.topPanel.setMinimumSize(new Dimension(34, 250));
        this.add((Component)this.topPanel, "North");
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
        this.bottomPanel = new JPanel();
        this.add((Component)this.bottomPanel, "South");
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
    }

    protected void addTables(AbstractTableModel tableModel, AbstractTableModel tableModel2) {
        this.table = new JTable(tableModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.addMouseListener(this);
        this.table2 = new JTable(tableModel2);
        this.table2.setAutoCreateRowSorter(true);
        this.scrollPane = new JScrollPane(this.table, 22, 32);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        String PREV = "prev";
        String NEXT = "next";
        InputMap inMap = this.table.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMap = this.table.getActionMap();
        actMap.put(PREV, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ExperimentTab.this.table.getSelectedRow();
                if (row > 0) {
                    ExperimentTab.this.displayRow(ExperimentTab.this.table, -1, row - 1);
                }
            }
        });
        actMap.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ExperimentTab.this.table.getSelectedRow();
                if (row < ExperimentTab.this.table.getRowCount() - 1) {
                    ExperimentTab.this.displayRow(ExperimentTab.this.table, -1, row + 1);
                }
            }
        });
        this.centerPanel.add(this.scrollPane);
        this.scrollPane2 = new JScrollPane(this.table2, 22, 32);
        this.table2.setFillsViewportHeight(true);
        this.table2.setAutoResizeMode(0);
        this.centerPanel.add(this.scrollPane2);
        this.table2.addMouseListener(this);
        InputMap packetinMap = this.table2.getInputMap(1);
        packetinMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        packetinMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap packetactMap = this.table2.getActionMap();
        packetactMap.put(PREV, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ExperimentTab.this.table2.getSelectedRow();
                if (row > 0) {
                    ExperimentTab.this.displayRow(ExperimentTab.this.table2, -1, row - 1);
                }
            }
        });
        packetactMap.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ExperimentTab.this.table2.getSelectedRow();
                if (row < ExperimentTab.this.table2.getRowCount() - 1) {
                    ExperimentTab.this.displayRow(ExperimentTab.this.table2, -1, row + 1);
                }
            }
        });
    }

    protected abstract void displayRow(JTable var1, int var2, int var3);

    protected abstract void parseExperimentFrames();

    protected void parseRawBytes(String[][] data, ExperimentLayoutTableModel radTableModel) {
        long[][] keyRawData = new long[data.length][2];
        String[][] rawData = new String[data.length][data[0].length - 2];
        int i = 0;
        while (i < data.length) {
            int k = 0;
            while (k < data[0].length) {
                try {
                    if (k <= 1) {
                        keyRawData[i][k] = Long.parseLong(data[data.length - i - 1][k]);
                    } else {
                        rawData[i][k - 2] = Integer.toHexString(Integer.valueOf(data[data.length - i - 1][k]));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++k;
            }
            ++i;
        }
        radTableModel.setData(keyRawData, rawData);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawBytes) {
            Config.displayRawRadData = e.getStateChange() != 2;
            if (this.showRawBytes.isSelected()) {
                this.scrollPane2.setVisible(false);
                this.scrollPane.setVisible(true);
            } else {
                this.scrollPane2.setVisible(true);
                this.scrollPane.setVisible(false);
            }
            this.parseExperimentFrames();
            Config.save();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int fromRow = -1;
        JTable table = (JTable)e.getSource();
        int row = table.rowAtPoint(e.getPoint());
        int col = table.columnAtPoint(e.getPoint());
        if (e.isShiftDown()) {
            fromRow = table.getSelectedRow();
            int n = table.getSelectedRowCount();
            if (row == fromRow) {
                fromRow = fromRow + n - 1;
            }
        }
        if (row >= 0 && col >= 0) {
            this.displayRow(table, fromRow, row);
        }
    }
}

