/*
 * Decompiled with CFR 0.152.
 */
package gui.graph;

import common.Log;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import telemetry.legacyPayloads.CameraJpeg;

public class MapPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected BufferedImage image;

    public MapPanel() {
    }

    public MapPanel(String filePath) {
        this.setImage(filePath);
    }

    private void setImage(String filePath) {
        try {
            this.image = ImageIO.read(new File(filePath));
        }
        catch (IOException ex) {
            Log.errorDialog("ERROR", "Could not set map image: " + filePath + "\n" + ex.getMessage());
        }
    }

    public void setBufferedImage(BufferedImage img) {
        this.image = img;
        this.repaint();
    }

    protected void paintMap(Graphics g, int x, int y, int graphHeight, int graphWidth) {
        if (this.image != null) {
            BufferedImage display = this.image;
            if (graphHeight < this.image.getHeight() || graphWidth < this.image.getWidth()) {
                double ratio = (double)graphHeight / (double)this.image.getHeight();
                if ((double)this.image.getWidth() * ratio > (double)graphWidth) {
                    ratio = (double)graphWidth / (double)this.image.getWidth();
                }
                if (ratio > 0.0) {
                    display = CameraJpeg.scale(this.image, ratio);
                }
            }
            g.drawImage(display, x, y, null);
        }
    }
}

