/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Log;
import java.util.ArrayList;

public class CircularBuffer
extends ArrayList<Boolean> {
    int bufferSize = 0;
    int startPointer = 0;
    int endPointer = -1;

    public CircularBuffer(int initialSize) {
        super(initialSize);
        this.bufferSize = initialSize;
        this.startPointer = this.bufferSize - 1;
        int i = 0;
        while (i < this.bufferSize) {
            super.add(false);
            ++i;
        }
        Log.println("Created circular buffer with " + initialSize + " bits");
    }

    public int getStartPointer() {
        return this.startPointer;
    }

    public int getEndPointer() {
        return this.endPointer;
    }

    @Override
    public boolean add(Boolean o) {
        ++this.endPointer;
        if (this.endPointer == this.bufferSize) {
            this.endPointer = 0;
        }
        if (this.endPointer == this.startPointer) {
            --this.endPointer;
            if (this.endPointer == -1) {
                this.endPointer = this.bufferSize - 1;
            }
            throw new IndexOutOfBoundsException("End pointer has reached start pointer");
        }
        super.set(this.endPointer, o);
        return true;
    }

    private int incPointer(int pointer, int amount) {
        int p = pointer + amount;
        if (p >= this.bufferSize) {
            p %= this.bufferSize;
        }
        return p;
    }

    @Override
    public Boolean get(int i) {
        if (i > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to read past end pointer");
        }
        int p = this.incPointer(this.startPointer, i);
        return (Boolean)super.get(p);
    }

    public void incStartPointer(int amount) {
        this.startPointer = this.incPointer(this.startPointer, amount);
    }

    @Override
    public int size() {
        int size = 0;
        if (this.endPointer >= this.startPointer) {
            size = this.endPointer - this.startPointer;
        } else {
            size = this.bufferSize - this.startPointer;
            size += this.endPointer;
        }
        return size;
    }
}

