/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Log;

public class Location {
    public String maidenhead;
    public float latitude;
    public float longitude;
    String U = "ABCDEFGHIJKLMNOPQRSTUVWX";
    String L = this.U.toLowerCase();

    public Location(String p1, String p2) {
        float lat = -100.0f;
        float lon = 0.0f;
        try {
            lat = Float.parseFloat(p1);
            lon = Float.parseFloat(p2);
            this.maidenhead = this.latLonToGridSquare(lat, lon);
        }
        catch (Exception e) {
            Log.errorDialog("ERROR", e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
    }

    public Location(float lat, float lon) {
        try {
            this.maidenhead = this.latLonToGridSquare(lat, lon);
        }
        catch (Exception e) {
            Log.errorDialog("ERROR", e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
    }

    public Location(String mh) {
        try {
            this.gridSquareToLatLon(mh);
        }
        catch (Exception e) {
            Log.errorDialog("ERROR", e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
    }

    private void gridSquareToLatLon(String grid) throws Exception {
        if (grid.length() != 6) {
            throw new Exception("Maidenhead locator needs to be 6 characters");
        }
        grid = grid.toUpperCase();
        char GLon = grid.charAt(0);
        char GLat = grid.charAt(1);
        char nLon = grid.charAt(2);
        char nLat = grid.charAt(3);
        char gLon = grid.charAt(4);
        char gLat = grid.charAt(5);
        float lon = this.U.indexOf(GLon);
        lon *= 20.0f;
        lon += (float)(Character.getNumericValue(nLon) * 2);
        lon += ((float)this.U.indexOf(gLon) + 0.5f) * 5.0f / 60.0f;
        if (Float.isNaN(lon -= 180.0f)) {
            throw new Exception("lon is NaN");
        }
        if (Math.abs(lon) > 180.0f) {
            throw new Exception("invalid longitude: " + lon);
        }
        this.longitude = lon;
        float lat = this.U.indexOf(GLat);
        lat *= 10.0f;
        lat += (float)Character.getNumericValue(nLat);
        lat += ((float)this.U.indexOf(gLat) + 0.5f) * 2.5f / 60.0f;
        if (Float.isNaN(lat -= 90.0f)) {
            throw new Exception("lat is NaN");
        }
        if ((double)Math.abs(lat) == 90.0) {
            throw new Exception("grid squares invalid at N/S poles");
        }
        if (Math.abs(lat) > 90.0f) {
            throw new Exception("invalid latitude: " + lat);
        }
        this.latitude = lat;
    }

    public String latLonToGridSquare(float lat, float lon) throws Exception {
        String U = "ABCDEFGHIJKLMNOPQRSTUVWX";
        String L = U.toLowerCase();
        if (Float.isNaN(lat)) {
            throw new Exception("lat is NaN");
        }
        if (Float.isNaN(lon)) {
            throw new Exception("lon is NaN");
        }
        if ((double)Math.abs(lat) == 90.0) {
            throw new Exception("grid squares invalid at N/S poles");
        }
        if (Math.abs(lat) > 90.0f) {
            throw new Exception("invalid latitude: " + lat);
        }
        if (Math.abs(lon) > 180.0f) {
            throw new Exception("invalid longitude: " + lon);
        }
        float adjLat = lat + 90.0f;
        float adjLon = lon + 180.0f;
        char GLat = U.charAt((int)(adjLat / 10.0f));
        char GLon = U.charAt((int)(adjLon / 20.0f));
        String nLat = "" + (int)(adjLat % 10.0f);
        String nLon = "" + (int)(adjLon / 2.0f % 10.0f);
        float rLat = (adjLat - (float)((int)adjLat)) * 60.0f;
        float rLon = (adjLon - (float)(2 * (int)(adjLon / 2.0f))) * 60.0f;
        char gLat = L.charAt((int)((double)rLat / 2.5));
        char gLon = L.charAt((int)(rLon / 5.0f));
        String locator = "" + GLon + GLat + nLon + nLat + gLon + gLat;
        return locator;
    }
}

