/*
 * Decompiled with CFR 0.152.
 */
import common.Config;
import common.Log;
import common.Spacecraft;
import decoder.Decoder;
import decoder.FoxBPSK.FoxBPSKCostasDecoder;
import decoder.FoxBPSK.FoxBPSKDotProdDecoder;
import decoder.FoxFskDecoder;
import decoder.SourceWav;
import gui.InitalSettings;
import gui.MainWindow;
import gui.ProgressPanel;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import telemetry.Format.TelemFormat;

public class FoxTelemMain {
    public static String HELP = "AMSAT Fox Telemetry Decoder. Version " + Config.VERSION + "\n\n" + "Usage: FoxTelem [-h][-v][-s][-o offset-freq] [--process-audio filename --telem-format format] [--12khz-if] [logFileDir]\n" + "-h Show this help.\n" + "-v Display version information.\n" + "-s Automatically start the decoder if in gui mode.\n" + "-o Set the offset frequency for the IQ demodulation" + "--process-audio <fileName> - Decode a wav file with no gui.  Must also supply a telem-format.\n" + "--telem-format <duv|high-speed|FOX_BPSK|GOLF_BPSK> - telemetry decoder to use.\n" + "--12khz-if - Use a 12kHz IF for audio file decoding.\n" + "logFileDir - Start the decoder in this directory and use the settings stored there.\n\n";
    static String seriousErrorMsg;
    static String logFileDir;
    static int REQUIRED_JAVA_VERSION;
    public static Exception launchException;

    static {
        logFileDir = null;
        REQUIRED_JAVA_VERSION = 8;
    }

    public static void main(String[] args) {
        try {
            String javaVersion = System.getProperty("java.specification.version");
            int release = Integer.parseInt(javaVersion.split("\\.")[1]);
            if (release < REQUIRED_JAVA_VERSION) {
                Log.errorDialog("Java Version Error", "FoxTelem needs Java Version " + REQUIRED_JAVA_VERSION + " or higher.  You are using Java Version: " + release + "\n" + "Please install a later version of Java.");
                System.exit(1);
            }
        }
        catch (Exception javaVersion) {
            // empty catch block
        }
        File audioFile = null;
        String telemFormatName = null;
        boolean use12khzIfSwitch = false;
        double offset = 0.0;
        int arg = 0;
        while (arg < args.length) {
            if (args[arg].startsWith("-")) {
                if (args[arg].equalsIgnoreCase("-h") || args[arg].equalsIgnoreCase("--help")) {
                    System.out.println(HELP);
                    System.exit(0);
                }
                if (args[arg].equalsIgnoreCase("-v") || args[arg].equalsIgnoreCase("--version")) {
                    System.out.println("AMSAT Fox Telemetry Decoder. Version " + Config.VERSION);
                    System.exit(0);
                }
                if (args[arg].equalsIgnoreCase("-s")) {
                    Log.println("Command Line Switch: STARTED");
                    Config.startButtonPressed = true;
                }
                if (args[arg].equalsIgnoreCase("--12khz-if")) {
                    Log.println("Command Line Switch: 12kHz IF");
                    use12khzIfSwitch = true;
                }
                if (args[arg].equalsIgnoreCase("-o") || args[arg].equalsIgnoreCase("--offset")) {
                    offset = Double.parseDouble(args[++arg]);
                }
                if (args[arg].equalsIgnoreCase("--telem-format")) {
                    if (args.length == ++arg) {
                        System.out.println("Missing filename for --telem-format command line switch.");
                        System.exit(0);
                    }
                    telemFormatName = args[arg];
                    Log.println("Command Line Switch: Telem Format File: " + telemFormatName);
                }
                if (args[arg].equalsIgnoreCase("--process-audio")) {
                    String audioFileName;
                    if (args.length == ++arg) {
                        System.out.println("Missing filename for --process-audio command line switch.");
                        System.exit(0);
                    }
                    if (!(audioFile = new File(audioFileName = args[arg])).isFile()) {
                        System.out.println("Can't read file for --process-audio command line switch: " + audioFileName);
                        System.exit(0);
                    }
                    Log.println("Command Line Switch: Process Audio File: " + audioFileName);
                }
            } else {
                Log.println("Command Line Param LogFileDir: " + args[arg]);
                logFileDir = args[arg];
            }
            ++arg;
        }
        if (audioFile != null) {
            Log.showGuiDialogs = false;
        }
        ProgressPanel initProgress = null;
        if (audioFile == null) {
            initProgress = new ProgressPanel(MainWindow.frame, "Initializing AMSAT FoxTelem, please wait ...", false);
            initProgress.setVisible(true);
        }
        Config.homeDirectory = logFileDir == null ? String.valueOf(System.getProperty("user.home")) + File.separator + ".FoxTelem" : logFileDir;
        FoxTelemMain m = new FoxTelemMain();
        if (Config.setup("FoxTelem.properties")) {
            if (audioFile != null) {
                Log.println("Cant process command Line Switch 'Process Audio File' until FoxTelem is setup\nRun the GUI once to pick installed satellites and initialize the settings for processing\n");
                System.exit(1);
            }
            Config.setHome();
            if (logFileDir == null) {
                m.initialRun();
            }
        }
        Log.init("FoxTelemDecoder");
        Config.currentDir = System.getProperty("user.dir");
        Config.spacecraftDir = String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR;
        Config.init(logFileDir);
        Log.println("************************************************************");
        Log.println("AMSAT Fox 1A Telemetry Decoder. " + Config.VERSION + "\nCurrentDir is: " + Config.currentDir);
        Log.println("************************************************************");
        Log.println("LogFileDir is:" + Config.logFileDirectory);
        if (offset > 0.0) {
            Config.selectedFrequency = offset;
        }
        if (audioFile != null) {
            m.processAudioFile(audioFile, telemFormatName, use12khzIfSwitch);
        } else {
            FoxTelemMain.invokeGUI();
            initProgress.updateProgress(100);
        }
    }

    public void initialRun() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JFrame window = new JFrame();
            window.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/fox.jpg")));
            InitalSettings f = new InitalSettings(window, true);
            f.setVisible(true);
        }
        catch (Exception e) {
            Log.println("SERIOUS ERROR - Uncaught and thrown from Initial Setup");
            e.printStackTrace();
            e.printStackTrace(Log.getWriter());
            Log.errorDialog("SERIOUS ERROR - Uncaught and thrown from Initial Setup", e.getMessage());
        }
    }

    public static void invokeGUI() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        System.setProperty("sun.awt.exception.handler", ExceptionHandler.class.getName());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Config.mainWindow = new MainWindow();
                    Config.mainWindow.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/fox.jpg")));
                    Config.mainWindow.setVisible(true);
                }
                catch (Exception e) {
                    launchException = e;
                    Log.println("SERIOUS ERROR - Uncaught and thrown from GUI");
                    seriousErrorMsg = "Something is preventing FoxTelem from running.  If you recently changed the\nspacecraft files then try reverting to an older version, or install the standard files.  \nIf that does not work then you can try deleting the FoxTelem.properties\nfile in your home directory, in a sub directory called .FoxTelem, though this\nwill delete your settings\n\nThere may be more details of the error in the log file.  You can enable logging by \nsetting logging=true in FoxTelem.properties.\n";
                    e.printStackTrace();
                    e.printStackTrace(Log.getWriter());
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Frame frm = new Frame();
                            String stacktrace = Log.makeShortTrace(launchException.getStackTrace());
                            JOptionPane.showMessageDialog(frm, seriousErrorMsg, "SERIOUS ERROR - Uncaught and thrown from GUI\n" + launchException.getMessage() + "\n" + stacktrace, 0);
                            System.exit(99);
                        }
                    });
                }
            }
        });
    }

    void processAudioFile(File wavFile, String telemFormatName, boolean use12khzIfSwitch) {
        if (telemFormatName == null) {
            Log.println("Missing telem format.  Include command line switch --telem-format with a valid format from this list: duv high-speed FOX_BPSK GOLF_BPSK");
            System.exit(1);
        }
        if (use12khzIfSwitch) {
            Config.use12kHzIfForBPSK = true;
        }
        SourceWav audioSource = null;
        try {
            audioSource = new SourceWav(wavFile.getPath(), false);
        }
        catch (UnsupportedAudioFileException e) {
            Log.errorDialog("ERROR With Audio File", e.toString());
            e.printStackTrace(Log.getWriter());
        }
        catch (IOException e) {
            Log.errorDialog("ERROR With File", e.toString());
            e.printStackTrace(Log.getWriter());
        }
        Decoder decoder1 = null;
        TelemFormat telemFormat = null;
        if (telemFormatName != null && (telemFormat = Config.satManager.getFormatByName(telemFormatName)) == null) {
            System.out.println("Can't read file for --telem-fomat command line switch: " + telemFormatName);
            System.exit(0);
        }
        if (telemFormat.isFSK()) {
            decoder1 = new FoxFskDecoder(audioSource, 0, telemFormat);
        } else if (telemFormat.isBPSK()) {
            decoder1 = Config.useCostas ? new FoxBPSKCostasDecoder(audioSource, 0, 1, telemFormat) : new FoxBPSKDotProdDecoder(audioSource, 0, 0, telemFormat);
        } else {
            Log.println("Unknown format: " + telemFormatName);
            System.exit(1);
        }
        if (decoder1 == null) {
            Log.println("Could not initialize decoder.  Try using --telem-format for BPSK modes ... exiting");
            System.exit(1);
        }
        try {
            decoder1.process();
        }
        catch (UnsupportedAudioFileException e) {
            Log.println("ERROR: " + e);
        }
        catch (IOException e) {
            Log.println("ERROR: " + e);
        }
        catch (NullPointerException e) {
            Log.println("ERROR: " + e);
            Log.println("FATAL ERROR IN DECODER: Uncaught null exception." + e + "\n" + e.getStackTrace());
        }
        catch (Exception e) {
            Log.println("FATAL: Uncaught exception." + e + "\n" + e.getStackTrace());
        }
        Log.println("DECODER Exit");
        Log.println("Finished processing audio file.");
        System.exit(0);
    }

    private String getCurrentDir() {
        Class<?> cls = this.getClass();
        ProtectionDomain pDomain = cls.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        URL loc = cSource.getLocation();
        String dir = loc.getPath();
        File f = new File(dir);
        String s = f.getParent();
        return s;
    }

    public static String[] consumeArg(String[] args) {
        String[] a = new String[args.length - 1];
        int j = 1;
        while (j < args.length) {
            a[j - 1] = args[j];
            ++j;
        }
        return a;
    }

    public static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public void handle(Throwable thrown) {
            this.handleException(Thread.currentThread().getName(), thrown);
        }

        @Override
        public void uncaughtException(Thread thread, Throwable thrown) {
            this.handleException(thread.getName(), thrown);
        }

        protected void handleException(String tname, Throwable thrown) {
            String stacktrace = Log.makeShortTrace(thrown.getStackTrace());
            Log.errorDialog("SERIOUS EDT ERROR", "Exception on " + tname + ":" + thrown + "\n" + stacktrace);
        }
    }
}

